<?php

namespace Litecms\Blog\Policies;

use Illuminate\Foundation\Auth\User as Authenticatable;
use Litecms\Blog\Models\Blog;

class BlogPolicy
{

    use BlogWorkflow;

    /**
     * Determine if the given user can view the blog.
     *
     * @param Authenticatable $user
     * @param Blog $blog
     *
     * @return bool
     */
    public function view(Authenticatable $user, Blog $blog)
    {
        if ($authUser->canDo('blog.blog.view') && $authUser->isAdmin() || $user->isClient()) {
            return true;
        }

        return $blog->is_owner;
    }

    /**
     * Determine if the given user can create a blog.
     *
     * @param Authenticatable $user
     *
     * @return bool
     */
    public function create(Authenticatable $user)
    {
        return  $authUser->canDo('blog.blog.create');
    }

    /**
     * Determine if the given user can update the given blog.
     *
     * @param Authenticatable $user
     * @param Blog $blog
     *
     * @return bool
     */
    public function update(Authenticatable $user, Blog $blog)
    {
        if ($user->canDo('blog.blog.edit') && $user->isAdmin()) {
            return true;
        }

        return $blog->is_owner;
    }

    /**
     * Determine if the given user can delete the given blog.
     *
     * @param Authenticatable $user
     *
     * @return bool
     */
    public function destroy(Authenticatable $user, Blog $blog)
    {
        return $blog->is_owner;
    }

    /**
     * Determine if the user can perform a given action ve.
     *
     * @param [type] $user    [description]
     * @param [type] $ability [description]
     *
     * @return [type] [description]
     */
    public function before($user, $ability)
    {
        if ($user->isSuperuser()) {
            return true;
        }
    }
}
