<?php

namespace Litecms\Blog\Listeners;

use Illuminate\Support\Facades\Notification;
use Illuminate\Support\Str;
use Litecms\Blog\Events\TagAction as TagActionEvent;
use Litecms\Blog\Notifications\TagAction as TagActionNotification;
use Litepie\Actions\Concerns\AsAction;

class TagAction
{
    use AsAction;

    private $allowedActions = [
        'before' => [],
        'after' => ['create'],
    ];

    /**
     * Handle the TagActionEvent.
     *
     * @param   TagActionEvent  $event
     * @return mixed
     */
    public function handle(TagActionEvent $event)
    {
        $function = Str::camel($event->action);
        return $this->$function($event);
    }

    /**
     * Create a new $tag.
     *
     * @param   TagActionEvent  $event
     * @return void
     */
    public function create(TagActionEvent $event)
    {
        $client = $event->tag->client;
        Notification::send($client, new TagActionNotification($event));
    }

    /**
     * Handle the TagActionEvent as a listener.
     *
     * @param   TagActionEvent  $event
     * @return mixed
     */
    public function asListener(TagActionEvent $event)
    {
        if ($this->isAllowed($event)) {
            return $this->handle($event);
        }
    }

    /**
     * Check if the event action is allowed.
     *
     * @param   TagActionEvent  $event
     * @return bool
     */
    private function isAllowed(TagActionEvent $event)
    {
        if ($event->when == 'before' &&
            !in_array($event->action, $this->allowedActions['before'])) {
            return false;
        }

        if (($event->when == 'after' &&
            !in_array($event->action, $this->allowedActions['after']))
        ) {
            return false;
        }

        return true;
    }
}
