<?php

namespace Litecms\Blog\Listeners;

use Illuminate\Support\Facades\Notification;
use Illuminate\Support\Str;
use Litecms\Blog\Events\CategoryAction as CategoryActionEvent;
use Litecms\Blog\Notifications\CategoryAction as CategoryActionNotification;
use Litepie\Actions\Concerns\AsAction;

class CategoryAction
{
    use AsAction;

    private $allowedActions = [
        'before' => [],
        'after' => ['create'],
    ];

    /**
     * Handle the CategoryActionEvent.
     *
     * @param   CategoryActionEvent  $event
     * @return mixed
     */
    public function handle(CategoryActionEvent $event)
    {
        $function = Str::camel($event->action);
        return $this->$function($event);
    }

    /**
     * Create a new $category.
     *
     * @param   CategoryActionEvent  $event
     * @return void
     */
    public function create(CategoryActionEvent $event)
    {
        $client = $event->category->client;
        Notification::send($client, new CategoryActionNotification($event));
    }

    /**
     * Handle the CategoryActionEvent as a listener.
     *
     * @param   CategoryActionEvent  $event
     * @return mixed
     */
    public function asListener(CategoryActionEvent $event)
    {
        if ($this->isAllowed($event)) {
            return $this->handle($event);
        }
    }

    /**
     * Check if the event action is allowed.
     *
     * @param   CategoryActionEvent  $event
     * @return bool
     */
    private function isAllowed(CategoryActionEvent $event)
    {
        if ($event->when == 'before' &&
            !in_array($event->action, $this->allowedActions['before'])) {
            return false;
        }

        if (($event->when == 'after' &&
            !in_array($event->action, $this->allowedActions['after']))
        ) {
            return false;
        }

        return true;
    }
}
