<?php

namespace Litecms\Blog\Listeners;

use Illuminate\Support\Facades\Notification;
use Illuminate\Support\Str;
use Litecms\Blog\Events\BlogAction as BlogActionEvent;
use Litecms\Blog\Notifications\BlogAction as BlogActionNotification;
use Litepie\Actions\Concerns\AsAction;

class BlogAction
{
    use AsAction;

    private $allowedActions = [
        'before' => [],
        'after' => ['create'],
    ];

    /**
     * Handle the BlogActionEvent.
     *
     * @param   BlogActionEvent  $event
     * @return mixed
     */
    public function handle(BlogActionEvent $event)
    {
        $function = Str::camel($event->action);
        return $this->$function($event);
    }

    /**
     * Create a new $blog.
     *
     * @param   BlogActionEvent  $event
     * @return void
     */
    public function create(BlogActionEvent $event)
    {
        $client = $event->blog->client;
        Notification::send($client, new BlogActionNotification($event));
    }

    /**
     * Handle the BlogActionEvent as a listener.
     *
     * @param   BlogActionEvent  $event
     * @return mixed
     */
    public function asListener(BlogActionEvent $event)
    {
        if ($this->isAllowed($event)) {
            return $this->handle($event);
        }
    }

    /**
     * Check if the event action is allowed.
     *
     * @param   BlogActionEvent  $event
     * @return bool
     */
    private function isAllowed(BlogActionEvent $event)
    {
        if ($event->when == 'before' &&
            !in_array($event->action, $this->allowedActions['before'])) {
            return false;
        }

        if (($event->when == 'after' &&
            !in_array($event->action, $this->allowedActions['after']))
        ) {
            return false;
        }

        return true;
    }
}
