<?php

namespace Litecms\Blog\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class TagResource extends JsonResource
{

    public function itemLink()
    {
        return guard_url('blog/tag') . '/' . $this->getRouteKey();
    }

    public function title()
    {
        if ($this->title != '') {
            return $this->title;
        }

        if ($this->name != '') {
            return $this->name;
        }

        return 'None';
    }

    public function toArray($request)
    {
        return [
            'id' => $this->getRouteKey(),
            'title' => $this->title(),
            'slug' => $this->slug,
            'name' => $this->name,
            'slug' => $this->slug,
            'status' => $this->status,
            'user_id' => $this->user_id,
            'user_type' => $this->user_type,
            'created_at' => !is_null($this->created_at) ? $this->created_at->format('Y-m-d H:i:s') : null,
            'updated_at' => !is_null($this->updated_at) ? $this->updated_at->format('Y-m-d H:i:s') : null,
            'meta' => [
                'exists' => $this->exists(),
                'link' => $this->itemLink(),
                'upload_url' => $this->getUploadURL(''),
                'workflow' => $this->workflows(),
                'actions' => $this->actions(),
            ],
        ];
    }

    /**
     * Get additional data that should be returned with the resource array.
     *
     * @param     \Illuminate\Http\Request  $request
     * @return array
     */
    public function with($request)
    {
        return [
            'meta' => [
                'exists' => $this->exists(),
                'link' => $this->itemLink(),
                'upload_url' => $this->getUploadURL(''),
                'workflow' => $this->workflows(),
                'actions' => $this->actions(),
            ],
        ];
    }

    /**
     * Get the workflows for the resource.
     *
     * @return array
     */
    private function workflows()
    {
        $arr = [];
                return $arr;

    }
    
    /**
     * Get the actions for the resource.
     *
     * @return array
     */
    private function actions()
    {

        $arr = [];
        
        return $arr;
    }
}
