<?php

namespace Litecms\Blog\Http\Controllers;

use App\Http\Controllers\PublicController as BaseController;
use App\Http\Requests\PublicRequest;
use Litepie\Database\RequestScope;
use Litecms\Blog\Http\Resources\BlogResource;
use Litecms\Blog\Http\Resources\BlogsCollection;
use Litecms\Blog\Scopes\BlogPublicScope;
use Litecms\Blog\Models\Blog;

class BlogPublicController extends BaseController
{

    /**
     * Show blog's list.
     *
     * @return response
     */
    protected function index(PublicRequest $request)
    {

        $search = $request->search;
        $pageLimit = $request->input('pageLimit', config('database.pagination.limit'));
        $page = Blog::pushScope(new RequestScope())
            ->pushScope(new BlogPublicScope())
            ->paginate($pageLimit)
            ->withQueryString();

        $blogs = new BlogsCollection($page);

        $categories = [];
        $tags = [];
        $recent = [];

        return $this->response->setMetaTitle(trans('blog::blog.names'))
            ->view('blog::public.blog.index')
            ->data(compact('blogs', 'categories', 'tags', 'recent'))
            ->output();
    }

    /**
     * Show blog.
     *
     * @param string $slug
     *
     * @return response
     */
    protected function show(PublicRequest $request, $slug)
    {
        $model = Blog::findBySlug($slug);
        $data = new BlogResource($model);

        $categories = [];
        $tags = [];
        $recent = [];
    
        return $this->response->setMetaTitle($data['title'] . trans('blog::blog.name'))
            ->view('blog::public.blog.show')
            ->data(compact('data', 'categories', 'tags', 'recent'))
            ->output();
    }

}
