<?php

namespace Litecms\Blog\Actions;

use Illuminate\Support\Carbon;
use Illuminate\Support\Str;
use Litepie\Actions\Concerns\AsAction;
use Litecms\Blog\Models\Tag;


class TagAction
{
    use AsAction;

    protected $model;
    protected $namespace = 'litecms.blog.tag';
    protected $eventClass = \Litecms\Blog\Events\TagAction::class;
    protected $action;
    protected $function;
    protected $request;

    public function handle(string $action, Tag $tag, array $request = [])
    {
        $this->action = $action;
        $this->request = $request;
        $this->model = $tag;
        $this->function = Str::camel($action);
        $this->executeAction();
        return $this->model;

    }


    public function store(Tag $tag, array $request)
    {
        $attributes = $request;
        $attributes['user_id'] = user_id();
        $attributes['user_type'] = user_type();
        $tag = $tag->create($attributes);
        return $tag;
    }

    public function update(Tag $tag, array $request)
    {
        $attributes = $request;
        $tag->update($attributes);
        return $tag;
    }

    public function destroy(Tag $tag, array $request)
    {
        $tag->delete();
        return $tag;
    }

    public function copy(Tag $tag, array $request)
    {
        $count = $request['count'] ?: 1;

        if ($count == 1) {
            $tag = $tag->replicate();
            $tag->created_at = Carbon::now();
            $tag->save();
            return $tag;
        }

        for ($i = 1; $i <= $count; $i++) {
            $new = $tag->replicate();
            $new->created_at = Carbon::now();
            $new->save();
        }

        return $tag;
    }


}
