<?php

namespace Litecms\Blog\Actions;

use Illuminate\Http\Request;
use Litecms\Blog\Models\Blog;
use Litepie\Actions\Concerns\AsAction;
use Illuminate\Support\Str;

class BlogWorkflow
{
    use AsAction;
    
    private $model;
    private $namespace = 'litecms.blog.$blog';
    private $transition;
    protected $eventClass = \Litecms\Blog\Events\BlogWorkflow::class;
    private $function;
    private $request;

    public function handle(string $transition, Blog $blog, array $request = [])
    {
        $this->model = $blog;
        $this->request = $request;
        $this->transition = $transition;
        $this->function = Str::camel($transition);
        $this->executeWorkflow();
        return $this->model;
    }

    public function submit()
    {
        $this->model->status = 'Pending';
        $this->model->save();
        return $this->model;
    }

    public function approve()
    {
        $this->model->status = 'Approved';
        $this->model->save();
        return $this->model;
    }

    public function reject()
    {
        $this->model->status = 'Draft';
        $this->model->save();
        return $this->model;
    }

    public function publish()
    {
        $this->model->status = 'Published';
        $this->model->save();
        return $this->model;
    }

    public function unpublish()
    {
        $this->model->status = 'Unpublished';
        $this->model->save();
        return $this->model;
    }

    public function archive()
    {
        $this->model->status = 'Archived';
        $this->model->save();
        return $this->model;
    }

    public function unarchive()
    {
        $this->model->status = 'Draft';
        $this->model->save();
        return $this->model;
    }
}
