<?php

namespace Litecms\Blog\Actions;

use Illuminate\Support\Str;
use Litecms\Blog\Models\Blog;
use Litecms\Blog\Scopes\BlogResourceScope;
use Litepie\Actions\Concerns\AsAction;
use Litepie\Actions\Traits\LogsActions;
use Litepie\Database\RequestScope;

class BlogActions
{
    use AsAction;
    use LogsActions;
    
    protected $model;
    protected $namespace = 'litecms.blog.blog';
    protected $eventClass = \Litecms\Blog\Events\BlogAction::class;
    protected $action;
    protected $function;
    protected $request;

    public function handle(string $action, array $request)
    {
        $this->model = app(Blog::class);
        $this->action = $action;
        $this->request = $request;
        $this->function = Str::camel($action);

        $function = Str::camel($action);

        $this->dispatchActionBeforeEvent();
        $data = $this->$function($request);
        $this->dispatchActionAfterEvent();

        $this->logsAction();
        return $data;

    }

    public function paginate(array $request)
    {
        $pageLimit = isset($request['pageLimit']) ?: config('database.pagination.limit');
        $blog = $this->model
            ->pushScope(new RequestScope())
            ->pushScope(new BlogResourceScope())
            ->paginate($pageLimit);

        return $blog;
    }

    public function simplePaginate(array $request)
    {
        $pageLimit = isset($request['pageLimit']) ?: config('database.pagination.limit');
        $blog = $this->model
            ->pushScope(new RequestScope())
            ->pushScope(new BlogResourceScope())
            ->simplePaginate($pageLimit);

        return $blog;
    }

    function empty(array $request) {
        return $this->model->forceDelete();
    }

    function restore(array $request) {
        return $this->model->restore();
    }

    public function delete(array $request)
    {
        $ids = $request['ids'];
        $ids = collect($ids)->map(function ($id) {
            return hashids_decode($id);
        });
        return $this->model->whereIn('id', $ids)->delete();
    }

    public function options(array $request)
    {
        return $this->model
            ->pushScope(new RequestScope())
            ->pushScope(new BlogResourceScope())
            ->take(30)->get()
            ->map(function ($row) {
                return [
                    'key' => $row->id,
                    'value' => $row->id,
                    'text' => $row->name,
                ];
            })->toArray();
    }
}
