<?php

namespace Litecms\Blog\Actions;

use Illuminate\Support\Carbon;
use Illuminate\Support\Str;
use Litepie\Actions\Concerns\AsAction;
use Litecms\Blog\Models\Blog;


class BlogAction
{
    use AsAction;

    protected $model;
    protected $namespace = 'litecms.blog.blog';
    protected $eventClass = \Litecms\Blog\Events\BlogAction::class;
    protected $action;
    protected $function;
    protected $request;

    public function handle(string $action, Blog $blog, array $request = [])
    {
        $this->action = $action;
        $this->request = $request;
        $this->model = $blog;
        $this->function = Str::camel($action);
        $this->executeAction();
        return $this->model;

    }


    public function store(Blog $blog, array $request)
    {
        $attributes = $request;
        $attributes['user_id'] = user_id();
        $attributes['user_type'] = user_type();
        $blog = $blog->create($attributes);
        return $blog;
    }

    public function update(Blog $blog, array $request)
    {
        $attributes = $request;
        $blog->update($attributes);
        return $blog;
    }

    public function destroy(Blog $blog, array $request)
    {
        $blog->delete();
        return $blog;
    }

    public function copy(Blog $blog, array $request)
    {
        $count = $request['count'] ?: 1;

        if ($count == 1) {
            $blog = $blog->replicate();
            $blog->created_at = Carbon::now();
            $blog->save();
            return $blog;
        }

        for ($i = 1; $i <= $count; $i++) {
            $new = $blog->replicate();
            $new->created_at = Carbon::now();
            $new->save();
        }

        return $blog;
    }


}
