@include('blog::public.blog.partial.header')
<section class="listing-page-wrap">
    <div class="container">
        <div class="row">
            @include('blog::public.blog.partial.aside')

            <div class="col-12 col-lg-9 left-sidebar" id="listing_data">
                @forelse($blogs as $blog)
                @php 
                $blog = $blog->toArray([]);
                @endphp
                <div class="listing-single-item d-flex align-items-center flex-wrap">
                    <div class="col-12 col-lg-5 p-0 listing-image">
                        <a href="{{trans_url('blog')}}/{{$blog['slug']}}">
                        <img src="{{url($blog['image']['main'])}}" class="img-fluid" alt="">
                        </a>
                    </div>
                    <div class="col-12 col-lg-6 p-0 listing-text">
                        <div class="listing-content">
                            <h3><a href="{{trans_url('blog')}}/{{$blog['slug']}}">{{$blog['title']}}</a></h3>
                            <div class="listing-metas">
                                <span>By <a
                                        href="{{trans_url('blog')}}/{{$blog['slug']}}">User</a></span>
                                <span><a
                                        href="{{trans_url('blog')}}/{{$blog['slug']}}">Category</a></span>
                            </div>
                            <p>{{ Str::limit($blog['description'], 300 )}}</p>
                        </div>
                        <a href="{{trans_url('blog')}}/{{$blog['slug']}}" class="btn btn-theme">Continue Reading</a>
                    </div>
                </div>
                <nav class="pagination-wrap mb-50" aria-label="Page navigation example">
                    <ul class="pagination">
                        @php 
                        $meta = $blog['meta'];
                        @endphp
                        {!!view('paginator', compact('meta'))!!}
                    </ul>
                </nav>
                @empty
                @endif
            </div>
        </div>
    </div>
</section>
