# Installation

The instructions below will help you to properly installand run the generated package to the lavalite project.

## Location

Extract the package contents to the folder 

`/packages/litecms/blog/`

## Composer

Add the below entries in the `composer.json`.


```json

...
     "repositories": {
        ...

        {
            "type": "path",
            "url": "packages/litecms/blog"
        }

        ...
    },
...

```
Then run `composer require litecms/blog`


## Migration and seeds

```
    php artisan migrate
    php artisan db:seed --class=Litecms\\Blog\\Seeders\\BlogTableSeeder
```

## Publishing

* Configuration
```
    php artisan vendor:publish --provider="Litecms\Blog\Providers\BlogServiceProvider" --tag="config"
```
* Language
```
    php artisan vendor:publish --provider="Litecms\Blog\Providers\BlogServiceProvider" --tag="lang"
```
* Views
```
    php artisan vendor:publish --provider="Litecms\Blog\Providers\BlogServiceProvider" --tag="view"
```

## URLs and APIs

### Web Urls

* Admin
```
    http://path-to-route-folder/admin/blog/{modulename}
```

* User
```
    http://path-to-route-folder/user/blog/{modulename}
```

* Public
```
    http://path-to-route-folder/blogs
```


### API endpoints

These endpoints can be used with or without `/api/`
And also the user can be varied depend on the type of users, eg user, client, admin etc.

#### Resource

* List
```
    http://path-to-route-folder/api/user/blog/{modulename}
    METHOD: GET
```

* Create
```
    http://path-to-route-folder/api/user/blog/{modulename}
    METHOD: POST
```

* Edit
```
    http://path-to-route-folder/api/user/blog/{modulename}/{id}
    METHOD: PUT
```

* Delete
```
    http://path-to-route-folder/api/user/blog/{modulename}/{id}
    METHOD: DELETE
```

#### Public

* List
```
    http://path-to-route-folder/api/blog/{modulename}
    METHOD: GET
```

* Single Item
```
    http://path-to-route-folder/api/blog/{modulename}/{slug}
    METHOD: GET
```

#### Others

* Report
```
    http://path-to-route-folder/api/user/blog/{modulename}/report/{report}
    METHOD: GET
```

* Export/Import
```
    http://path-to-route-folder/api/user/blog/{modulename}/exim/{exim}
    METHOD: POST
```

* Action
```
    http://path-to-route-folder/api/user/blog/{modulename}/action/{id}/{action}
    METHOD: PATCH
```

* Actions
```
    http://path-to-route-folder/api/user/blog/{modulename}/actions/{action}
    METHOD: PATCH
```

* Workflow
```
    http://path-to-route-folder/api/user/blog/{modulename}/workflow/{id}/{transition}
    METHOD: PATCH
```
