<?php

namespace Litecms\Blog\Seeders;

use Illuminate\Support\Facades\DB;
use Illuminate\Database\Seeder;

class TagTableSeeder extends Seeder
{
    public function run()
    {
        DB::table('litecms_blog_tags')->insert([
            
        ]);

        DB::table('permissions')->insert([
            [
                'slug'      => 'litecms.blog.tag.view',
                'name'      => 'View Tag',
            ],
            [
                'slug'      => 'litecms.blog.tag.create',
                'name'      => 'Create Tag',
            ],
            [
                'slug'      => 'litecms.blog.tag.edit',
                'name'      => 'Update Tag',
            ],
            [
                'slug'      => 'litecms.blog.tag.delete',
                'name'      => 'Delete Tag',
            ],
            
            
                    ]);

        DB::table('menus')->insert([
        
            // Admin menu
            [
                'parent_id'   => 1,
                'key'         => null,
                'url'         => 'admin/blog/tag',
                'name'        => 'Tag',
                'description' => null,
                'icon'        => 'las la-scroll',
                'target'      => null,
                'order'       => 190,
                'status'      => 1,
            ],
            
            // User menu.
            [
                'parent_id'   => 2,
                'key'         => null,
                'url'         => 'user/blog/tag',
                'name'        => 'Tag',
                'description' => null,
                'icon'        => 'las la-scroll',
                'target'      => null,
                'order'       => 190,
                'status'      => 1,
            ],

            // Public menu.
            [
                'parent_id'   => 3,
                'key'         => null,
                'url'         => 'tag',
                'name'        => 'Tag',
                'description' => null,
                'icon'        => 'las la-scroll,
                'target'      => null,
                'order'       => 190,
                'status'      => 1,
            ],

        ]);

        DB::table('settings')->insert([
            // Uncomment  and edit this section for entering value to settings table.
            /*
            [
                'pacakge'   => 'Blog',
                'module'    => 'Tag',
                'user_type' => null,
                'user_id'   => null,
                'key'       => 'litecms.blog.tag.key',
                'name'      => 'Some name',
                'value'     => 'Some value',
                'type'      => 'Default',
                'control'   => 'text',
            ],
            */
        ]);
    }
}
