<?php

namespace Litecms\Blog\Seeders;

use Illuminate\Support\Facades\DB;
use Illuminate\Database\Seeder;

class CategoryTableSeeder extends Seeder
{
    public function run()
    {
        DB::table('litecms_blog_categories')->insert([
            
        ]);

        DB::table('permissions')->insert([
            [
                'slug'      => 'litecms.blog.category.view',
                'name'      => 'View Category',
            ],
            [
                'slug'      => 'litecms.blog.category.create',
                'name'      => 'Create Category',
            ],
            [
                'slug'      => 'litecms.blog.category.edit',
                'name'      => 'Update Category',
            ],
            [
                'slug'      => 'litecms.blog.category.delete',
                'name'      => 'Delete Category',
            ],
            
            
                    ]);

        DB::table('menus')->insert([
        
            // Admin menu
            [
                'parent_id'   => 1,
                'key'         => null,
                'url'         => 'admin/blog/category',
                'name'        => 'Category',
                'description' => null,
                'icon'        => 'las la-scroll',
                'target'      => null,
                'order'       => 190,
                'status'      => 1,
            ],
            
            // User menu.
            [
                'parent_id'   => 2,
                'key'         => null,
                'url'         => 'user/blog/category',
                'name'        => 'Category',
                'description' => null,
                'icon'        => 'las la-scroll',
                'target'      => null,
                'order'       => 190,
                'status'      => 1,
            ],

            // Public menu.
            [
                'parent_id'   => 3,
                'key'         => null,
                'url'         => 'category',
                'name'        => 'Category',
                'description' => null,
                'icon'        => 'las la-scroll,
                'target'      => null,
                'order'       => 190,
                'status'      => 1,
            ],

        ]);

        DB::table('settings')->insert([
            // Uncomment  and edit this section for entering value to settings table.
            /*
            [
                'pacakge'   => 'Blog',
                'module'    => 'Category',
                'user_type' => null,
                'user_id'   => null,
                'key'       => 'litecms.blog.category.key',
                'name'      => 'Some name',
                'value'     => 'Some value',
                'type'      => 'Default',
                'control'   => 'text',
            ],
            */
        ]);
    }
}
