<?php

namespace Litecms\Blog\Seeders;

use Illuminate\Support\Facades\DB;
use Illuminate\Database\Seeder;

class BlogTableSeeder extends Seeder
{
    public function run()
    {
        DB::table('litecms_blog_blogs')->insert([
            
        ]);

        DB::table('permissions')->insert([
            [
                'slug'      => 'litecms.blog.blog.view',
                'name'      => 'View Blog',
            ],
            [
                'slug'      => 'litecms.blog.blog.create',
                'name'      => 'Create Blog',
            ],
            [
                'slug'      => 'litecms.blog.blog.edit',
                'name'      => 'Update Blog',
            ],
            [
                'slug'      => 'litecms.blog.blog.delete',
                'name'      => 'Delete Blog',
            ],
            
                        [
                'slug'      => 'litecms.blog.blog.verify',
                'name'      => 'Verify Blog',
            ],
            [
                'slug'      => 'litecms.blog.blog.approve',
                'name'      => 'Approve Blog',
            ],
            [
                'slug'      => 'litecms.blog.blog.publish',
                'name'      => 'Publish Blog',
            ],
            [
                'slug'      => 'litecms.blog.blog.unpublish',
                'name'      => 'Unpublish Blog',
            ],
            [
                'slug'      => 'litecms.blog.blog.cancel',
                'name'      => 'Cancel Blog',
            ],
            [
                'slug'      => 'litecms.blog.blog.archive',
                'name'      => 'Archive Blog',
            ],
            
                    ]);

        DB::table('menus')->insert([
        
            // Admin menu
            [
                'parent_id'   => 1,
                'key'         => null,
                'url'         => 'admin/blog/blog',
                'name'        => 'Blog',
                'description' => null,
                'icon'        => 'las la-scroll',
                'target'      => null,
                'order'       => 190,
                'status'      => 1,
            ],
            
            // User menu.
            [
                'parent_id'   => 2,
                'key'         => null,
                'url'         => 'user/blog/blog',
                'name'        => 'Blog',
                'description' => null,
                'icon'        => 'las la-scroll',
                'target'      => null,
                'order'       => 190,
                'status'      => 1,
            ],

            // Public menu.
            [
                'parent_id'   => 3,
                'key'         => null,
                'url'         => 'blog',
                'name'        => 'Blog',
                'description' => null,
                'icon'        => 'las la-scroll,
                'target'      => null,
                'order'       => 190,
                'status'      => 1,
            ],

        ]);

        DB::table('settings')->insert([
            // Uncomment  and edit this section for entering value to settings table.
            /*
            [
                'pacakge'   => 'Blog',
                'module'    => 'Blog',
                'user_type' => null,
                'user_id'   => null,
                'key'       => 'litecms.blog.blog.key',
                'name'      => 'Some name',
                'value'     => 'Some value',
                'type'      => 'Default',
                'control'   => 'text',
            ],
            */
        ]);
    }
}
