<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;

class CreateLitecmsBlogBlogsTable extends Migration
{
    /*
     * Run the migrations.
     *
     * @return void
     */

    public function up()
    {

        /*
         * Table: litecms_blog_blogs
         */
        Schema::create('litecms_blog_blogs', function ($table) {
            $table->increments('id');
            $table->string('title', 255)->nullable();
            $table->text('summary')->nullable();
            $table->text('description')->nullable();
            $table->text('images')->nullable();
            $table->integer('category_id')->nullable();
            $table->string('tags', 225)->nullable();
            $table->integer('viewcount')->nullable();
            $table->string('slug', 255)->nullable();
            $table->enum('status', ['Yes', 'No'])->nullable();
            $table->integer('user_id')->nullable();
            $table->string('user_type', 255)->nullable();
            $table->text('marking', 200)->nullable();
            $table->softDeletes();
            $table->nullableTimestamps();
        });
    }

    /*
    * Reverse the migrations.
    *
    * @return void
    */

    public function down()
    {
        Schema::drop('litecms_blog_blogs');
    }
}
