<?php


return  
    [
        'model' => [
            'model' => \Litecms\Blog\Models\Tag::class,
            'table' => 'litecms_blog_tags',
            'hidden'=> [],
            'visible' => [],
            'guarded' => ['*'],
            'slugs' => ['slug' => 'name'],
            'dates' => ['deleted_at', 'created_at', 'updated_at'],
            'appends' => [],
            'fillable' => ['name',  'status',  'user_id',  'user_type'],
            'translatables' => [],
            'upload_folder' => 'blog/tag',
            'uploads' => [
            /*
                    'images' => [
                        'count' => 10,
                        'type'  => 'image',
                    ],
                    'file' => [
                        'count' => 1,
                        'type'  => 'file',
                    ],
            */
            ],

            'casts' => [
            
            /*
                'images'    => 'array',
                'file'      => 'array',
            */
            ],

            'revision' => [],
            'perPage' => '20',
            'search'        => [
                'name'  => 'like',
                'status',
            ]
        ],

        'search' => [
            
        ],

        'list' => [
            [
                "key" => "name", 
                "type" => "text", 
                "label" => 'blog::tag.label.name', 
                'sort' => true,
                'roles' => [],
            ],
        ],

        'form' => [
            [
                "key" => 'name',
                "element" => 'text',
                "type" => 'text',
                "label" => 'blog::tag.label.name',
                "placeholder" => 'blog::tag.placeholder.name',
                "rules" => '',
                "group" => "main.main",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
        ],

        'urls' => [
            'new' => [
                'url' => 'blog/tag/new',
                'method' => 'GET',
            ],
            'create' => [
                'url' => 'blog/tag/create',
                'method' => 'GET',
            ],
            'store' => [
                'url' => 'blog/tag',
                'method' => 'POST',
            ],
            'update' => [
                'url' => 'blog/tag',
                'method' => 'PUT',
            ],
            'list' => [
                'url' => 'blog/tag',
                'method' => 'GET',
            ],
            'delete' => [
                'url' => 'blog/tag',
                'method' => 'DELETE',
            ],
        ],

        'order' => [
            'created_at' => 'blog::tag.label.created_at',
            'name' => 'blog::tag.label.name',
            'status' => 'blog::tag.label.status',
        ],

        'groups' => [
            [
                'icon' => "mdi:account-supervisor-outline",
                'name' => "blog::tag.groups.main",
                'group' => "main.main",
                'title' => "blog::tag.groups.main",
            ],
            [
                'icon' => "fe:home",
                'name' => "blog::tag.groups.details",
                'group' => "main.details",
                'title' => "blog::tag.groups.details",
            ],
            'images' => [
                'icon' => "fe:home",
                'name' => "blog::tag.groups.images",
                'group' => "main.images",
                'title' => "blog::tag.groups.images",
            ],
            'settings' => [
                'icon' => "fe:home",
                'name' => "blog::tag.groups.settings",
                'group' => "main.settings",
                'title' => "blog::tag.groups.settings",
            ]
        ],

        'controller' => [
            'provider' => 'Litecms',
            'package' => 'Blog',
            'module' => 'Tag',
        ],

        
        
    ];
