<?php


return  
    [
        'model' => [
            'model' => \Litecms\Blog\Models\Category::class,
            'table' => 'litecms_blog_categories',
            'hidden'=> [],
            'visible' => [],
            'guarded' => ['*'],
            'slugs' => ['slug' => 'name'],
            'dates' => ['deleted_at', 'created_at', 'updated_at'],
            'appends' => [],
            'fillable' => ['name',  'status',  'user_id',  'user_type'],
            'translatables' => [],
            'upload_folder' => 'blog/category',
            'uploads' => [
            /*
                    'images' => [
                        'count' => 10,
                        'type'  => 'image',
                    ],
                    'file' => [
                        'count' => 1,
                        'type'  => 'file',
                    ],
            */
            ],

            'casts' => [
            
            /*
                'images'    => 'array',
                'file'      => 'array',
            */
            ],

            'revision' => [],
            'perPage' => '20',
            'search'        => [
                'name'  => 'like',
                'status',
            ]
        ],

        'search' => [
            
        ],

        'list' => [
            [
                "key" => "name", 
                "type" => "text", 
                "label" => 'blog::category.label.name', 
                'sort' => true,
                'roles' => [],
            ],
        ],

        'form' => [
            [
                "key" => 'name',
                "element" => 'text',
                "type" => 'text',
                "label" => 'blog::category.label.name',
                "placeholder" => 'blog::category.placeholder.name',
                "rules" => '',
                "group" => "main.main",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
        ],

        'urls' => [
            'new' => [
                'url' => 'blog/category/new',
                'method' => 'GET',
            ],
            'create' => [
                'url' => 'blog/category/create',
                'method' => 'GET',
            ],
            'store' => [
                'url' => 'blog/category',
                'method' => 'POST',
            ],
            'update' => [
                'url' => 'blog/category',
                'method' => 'PUT',
            ],
            'list' => [
                'url' => 'blog/category',
                'method' => 'GET',
            ],
            'delete' => [
                'url' => 'blog/category',
                'method' => 'DELETE',
            ],
        ],

        'order' => [
            'created_at' => 'blog::category.label.created_at',
            'name' => 'blog::category.label.name',
            'status' => 'blog::category.label.status',
        ],

        'groups' => [
            [
                'icon' => "mdi:account-supervisor-outline",
                'name' => "blog::category.groups.main",
                'group' => "main.main",
                'title' => "blog::category.groups.main",
            ],
            [
                'icon' => "fe:home",
                'name' => "blog::category.groups.details",
                'group' => "main.details",
                'title' => "blog::category.groups.details",
            ],
            'images' => [
                'icon' => "fe:home",
                'name' => "blog::category.groups.images",
                'group' => "main.images",
                'title' => "blog::category.groups.images",
            ],
            'settings' => [
                'icon' => "fe:home",
                'name' => "blog::category.groups.settings",
                'group' => "main.settings",
                'title' => "blog::category.groups.settings",
            ]
        ],

        'controller' => [
            'provider' => 'Litecms',
            'package' => 'Blog',
            'module' => 'Category',
        ],

        
        
    ];
