<?php


return  
    [
        'model' => [
            'model' => \Litecms\Blog\Models\Blog::class,
            'table' => 'litecms_blog_blogs',
            'hidden'=> [],
            'visible' => [],
            'guarded' => ['*'],
            'slugs' => ['slug' => 'name'],
            'dates' => ['deleted_at', 'created_at', 'updated_at'],
            'appends' => [],
            'fillable' => ['title',  'summary',  'description',  'images',  'category_id',  'tags',  'viewcount',  'status',  'user_id',  'user_type'],
            'translatables' => [],
            'upload_folder' => 'blog/blog',
            'uploads' => [
            /*
                    'images' => [
                        'count' => 10,
                        'type'  => 'image',
                    ],
                    'file' => [
                        'count' => 1,
                        'type'  => 'file',
                    ],
            */
            ],

            'casts' => [
             
                'marking'    => 'array',
            
            /*
                'images'    => 'array',
                'file'      => 'array',
            */
            ],

            'revision' => [],
            'perPage' => '20',
            'search'        => [
                'name'  => 'like',
                'status',
            ]
        ],

        'search' => [
            
        ],

        'list' => [
            [
                "key" => "title", 
                "type" => "text", 
                "label" => 'blog::blog.label.title', 
                'sort' => true,
                'roles' => [],
            ],
            [
                "key" => "summary", 
                "type" => "text", 
                "label" => 'blog::blog.label.summary', 
                'sort' => true,
                'roles' => [],
            ],
            [
                "key" => "description", 
                "type" => "text", 
                "label" => 'blog::blog.label.description', 
                'sort' => true,
                'roles' => [],
            ],
            [
                "key" => "images", 
                "type" => "text", 
                "label" => 'blog::blog.label.images', 
                'sort' => true,
                'roles' => [],
            ],
            [
                "key" => "category_id", 
                "type" => "text", 
                "label" => 'blog::blog.label.category_id', 
                'sort' => true,
                'roles' => [],
            ],
            [
                "key" => "tags", 
                "type" => "text", 
                "label" => 'blog::blog.label.tags', 
                'sort' => true,
                'roles' => [],
            ],
            [
                "key" => "viewcount", 
                "type" => "text", 
                "label" => 'blog::blog.label.viewcount', 
                'sort' => true,
                'roles' => [],
            ],
        ],

        'form' => [
            [
                "key" => 'title',
                "element" => 'text',
                "type" => 'text',
                "label" => 'blog::blog.label.title',
                "placeholder" => 'blog::blog.placeholder.title',
                "rules" => '',
                "group" => "main.main",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            [
                "key" => 'summary',
                "element" => 'textarea',
                "type" => 'textarea',
                "label" => 'blog::blog.label.summary',
                "placeholder" => 'blog::blog.placeholder.summary',
                "rules" => '',
                "group" => "main.main",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            [
                "key" => 'description',
                "element" => 'html_editor',
                "type" => 'html_editor',
                "label" => 'blog::blog.label.description',
                "placeholder" => 'blog::blog.placeholder.description',
                "rules" => '',
                "group" => "main.main",
                "col" => "12",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            [
                "key" => 'images',
                "element" => 'file',
                "type" => 'images',
                "label" => 'blog::blog.label.images',
                "placeholder" => 'blog::blog.placeholder.images',
                "rules" => '',
                "group" => "main.main",
                "col" => "12",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            [
                "key" => 'category_id',
                "element" => 'select',
                "type" => 'select',
                "label" => 'blog::blog.label.category_id',
                "placeholder" => 'blog::blog.placeholder.category_id',
                "rules" => '',
                "options" => function(){
                    return trans('blog::blog.options.category_id');
                },
                "group" => "main.main",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            [
                "key" => 'tags',
                "element" => 'select',
                "type" => 'select',
                "label" => 'blog::blog.label.tags',
                "placeholder" => 'blog::blog.placeholder.tags',
                "rules" => '',
                "options" => function(){
                    return trans('blog::blog.options.tags');
                },
                "group" => "main.main",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            [
                "key" => 'viewcount',
                "element" => 'numeric',
                "type" => 'numeric',
                "label" => 'blog::blog.label.viewcount',
                "placeholder" => 'blog::blog.placeholder.viewcount',
                "rules" => '',
                "group" => "main.main",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
        ],

        'urls' => [
            'new' => [
                'url' => 'blog/blog/new',
                'method' => 'GET',
            ],
            'create' => [
                'url' => 'blog/blog/create',
                'method' => 'GET',
            ],
            'store' => [
                'url' => 'blog/blog',
                'method' => 'POST',
            ],
            'update' => [
                'url' => 'blog/blog',
                'method' => 'PUT',
            ],
            'list' => [
                'url' => 'blog/blog',
                'method' => 'GET',
            ],
            'delete' => [
                'url' => 'blog/blog',
                'method' => 'DELETE',
            ],
        ],

        'order' => [
            'created_at' => 'blog::blog.label.created_at',
            'name' => 'blog::blog.label.name',
            'status' => 'blog::blog.label.status',
        ],

        'groups' => [
            [
                'icon' => "mdi:account-supervisor-outline",
                'name' => "blog::blog.groups.main",
                'group' => "main.main",
                'title' => "blog::blog.groups.main",
            ],
            [
                'icon' => "fe:home",
                'name' => "blog::blog.groups.details",
                'group' => "main.details",
                'title' => "blog::blog.groups.details",
            ],
            'images' => [
                'icon' => "fe:home",
                'name' => "blog::blog.groups.images",
                'group' => "main.images",
                'title' => "blog::blog.groups.images",
            ],
            'settings' => [
                'icon' => "fe:home",
                'name' => "blog::blog.groups.settings",
                'group' => "main.settings",
                'title' => "blog::blog.groups.settings",
            ]
        ],

        'controller' => [
            'provider' => 'Litecms',
            'package' => 'Blog',
            'module' => 'Blog',
        ],

         
        'workflow' => [
            'type' => 'workflow',
            'marking_store' => [
                'type' => 'multiple_state',
                'arguments' => ['status'],
                // 'property' => 'status'
            ],
            'supports' => [
                \Litecms\Blog\Models\Blog::class,
            ],
            'places' => [
                'Draft',
                'Pending',
                'Approved',
                'Closed',
                'Published',
                'Archived',
                'Unpublished',
            ],
            'initial_places' => ['Draft'],
            'transitions' => [
                'submit' => [
                    'from' => 'Draft',
                    'to' => 'Pending',
                    'metadata' => [
                        'roles' => [
                            'user' => ['*'],
                        ],
                        'rules' => [
                            'name' => 'required',
                        ]
                    ],
                ],
                'reject' => [
                    'from' => 'Pending',
                    'to' => 'Draft',
                    'metadata' => [
                        'roles' => [
                            'user' => ['superuser'],
                            'team' => ['admin', 'manager'],
                        ],
                        'form' => [
                            'title' => 'Reject',
                            'button' => [
                                'cancel' > [
                                    'icon' > '',
                                    'varient' > '',
                                    'label' > 'Cancel'
                                ],
                                'submit' > [
                                    'icon' > '',
                                    'varient' > 'primary',
                                    'label' > 'Reject'
                                ]
                            ],
                            'fields' => [
                                'count' => [
                                    "element" => 'select',
                                    "type" => 'select',
                                    "label" => 'advert::advert.label.count',
                                    "placeholder" => 'advert::advert.placeholder.count',
                                    "options" => call_user_func(function () {
                                        return [
                                            1 => ['value' => 1, 'text' => 1],
                                            2 => ['value' => 2, 'text' => 2],
                                            3 => ['value' => 3, 'text' => 3],
                                            4 => ['value' => 4, 'text' => 4],
                                        ];
                                    }),
                                    "col" => "12",
                                ],
                                'comment' => [
                                    "element" => 'textarea',
                                    "type" => 'text',
                                    "required" => 'required',
                                    "label" => 'advert::advert.label.comment',
                                    "placeholder" => 'advert::advert.placeholder.comment',
                                    "col" => "12",
                                ],
                            ],
                        ],
                    ],
                ],
                'approve' => [
                    'from' => 'Pending',
                    'to' => 'Approved',
                    'metadata' => [
                        'roles' => [
                            'user' => ['superuser'],
                            'team' => ['admin', 'manager'],
                        ]
                    ],
                ],
                'publish' => [
                    'from' => ['Approved', 'Unpublished'],
                    'to' => 'Published',
                    'metadata' => [
                        'roles' => [
                            'user' => ['superuser'],
                            'team' => ['admin'],
                        ]
                    ],
                ],
                'unpublish' => [
                    'from' => ['Published'],
                    'to' => 'Unpublished',
                    'metadata' => [
                        'roles' => [
                            'user' => ['superuser', 'admin'],
                            'team' => ['admin'],
                        ]
                    ],
                ],
                'archive' => [
                    'from' => ['Published', 'Unpublished'],
                    'to' => 'Archived',
                    'metadata' => [
                        'roles' => [
                            'user' => ['superuser', 'admin'],
                            'team' => ['admin'],
                        ]
                    ],
                ],
                'unarchive' => [
                    'from' => ['Archived'],
                    'to' => 'Draft',
                    'metadata' => [
                        'roles' => [
                            'user' => ['superuser', 'admin'],
                            'team' => ['admin'],
                        ]
                    ],
                ],
            ],
        ],
        
        
    ];
