Lavalite package that provides a management facility for the cms.

## Installation

Begin by installing this package through Composer. Edit your project's `composer.json` file to require `arissa/a`.

    "arissa/a": "dev-master"

Next, update Composer from the Terminal:

    composer update

Once this operation completes execute below cammnds in command line to finalize installation.

    Arissa\A\Providers\AServiceProvider::class,

And also add it to alias

    'A'  => Arissa\A\Facades\A::class,

## Publishing files and migraiting database.

**Migration and seeds**

    php artisan migrate
    php artisan db:seed --class=Arissa\\A\\Seeders\\ATableSeeder

**Publishing configuration**

    php artisan vendor:publish --provider="Arissa\A\Providers\AServiceProvider" --tag="config"

**Publishing language**

    php artisan vendor:publish --provider="Arissa\A\Providers\AServiceProvider" --tag="lang"

**Publishing views**

    php artisan vendor:publish --provider="Arissa\A\Providers\AServiceProvider" --tag="view"


### Web Urls

**Admin**

    http://path-to-route-folder/admin/a/{modulename}

**User**

    http://path-to-route-folder/user/a/{modulename}

**Public**

    http://path-to-route-folder/as


### API endpoints

**List**

    http://path-to-route-folder/api/user/a/{modulename}
    METHOD: GET

**Create**

    http://path-to-route-folder/api/user/a/{modulename}
    METHOD: POST

**Edit**

    http://path-to-route-folder/api/user/a/{modulename}/{id}
    METHOD: PUT

**Delete**

    http://path-to-route-folder/api/user/a/{modulename}/{id}
    METHOD: DELETE

**Public List**

    http://path-to-route-folder/api/a/{modulename}
    METHOD: GET

**Public Single**

    http://path-to-route-folder/api/a/{modulename}/{slug}
    METHOD: GET