# Installation

The instructions below will help you to properly install the generated package to the lavalite project.

## Location

Extract the package contents to the folder 

`/packages/arissa/a/`

## Composer

Add the below entries in the `composer.json` file's autoload section and run the command `composer dump-autoload` in terminal.

```json

...
     "autoload": {

        "psr-4": {
            ... ,
            "Arissa\\A\\": "packages/arissa/a/src",
            "Arissa\\A\\Seeders\\": "packages/arissa/a/database/seeders"
            
            ...
        }
    },
...

```

## Config

Add the entries in service provider in `config/app.php`

```php

...
    'providers'       => [
        ...
        
        Arissa\A\Providers\AServiceProvider::class,
        
        ...
    ],

    ...

    'alias'             => [
        ...
        
        'A'  => Arissa\A\Facades\A::class,
        
        ...
    ]
...

```

## Migrate

After service provider is set run the commapnd to migrate and seed the database.


    php artisan migrate
    php artisan db:seed --class=Arissa\\A\\Seeders\\ATableSeeder

## Publishing


**Publishing configuration**

    php artisan vendor:publish --provider="Arissa\A\Providers\AServiceProvider" --tag="config"

**Publishing language**

    php artisan vendor:publish --provider="Arissa\A\Providers\AServiceProvider" --tag="lang"

**Publishing views**

    php artisan vendor:publish --provider="Arissa\A\Providers\AServiceProvider" --tag="view"


## URLs and APIs


### Web Urls

**Admin**

    http://path-to-route-folder/admin/a/{modulename}

**User**

    http://path-to-route-folder/user/a/{modulename}

**Public**

    http://path-to-route-folder/as


### API endpoints

**List**
 
    http://path-to-route-folder/api/user/a/{modulename}
    METHOD: GET

**Create**

    http://path-to-route-folder/api/user/a/{modulename}
    METHOD: POST

**Edit**

    http://path-to-route-folder/api/user/a/{modulename}/{id}
    METHOD: PUT

**Delete**

    http://path-to-route-folder/api/user/a/{modulename}/{id}
    METHOD: DELETE

**Public List**

    http://path-to-route-folder/api/a/{modulename}
    METHOD: GET

**Public Single**

    http://path-to-route-folder/api/a/{modulename}/{slug}
    METHOD: GET