# Installation

The instructions below will help you to properly install the generated package to the lavalite project.

## Location

Extract the package contents to the folder 

`/packages/frogship/pap_co/`

## Composer

Add the below entries in the `composer.json` file's autoload section and run the command `composer dump-autoload` in terminal.

```json

...
     "autoload": {
         ...

        "classmap": [
            ...
            
            "packages/frogship/pap_co/database/seeds",
            
            ...
        ],
        "psr-4": {
            ...
            
            "Frogship\\PapCo\\": "packages/frogship/pap_co/src",
            
            ...
        }
    },
...

```

## Config

Add the entries in service provider in `config/app.php`

```php

...
    'providers'       => [
        ...
        
        Frogship\PapCo\Providers\PapCoServiceProvider::class,
        
        ...
    ],

    ...

    'alias'             => [
        ...
        
        'PapCo'  => Frogship\PapCo\Facades\PapCo::class,
        
        ...
    ]
...

```

## Migrate

After service provider is set run the commapnd to migrate and seed the database.


    php artisan migrate
    php artisan db:seed --class=Frogship\\PapCoTableSeeder

## Publishing


**Publishing configuration**

    php artisan vendor:publish --provider="Frogship\PapCo\Providers\PapCoServiceProvider" --tag="config"

**Publishing language**

    php artisan vendor:publish --provider="Frogship\PapCo\Providers\PapCoServiceProvider" --tag="lang"

**Publishing views**

    php artisan vendor:publish --provider="Frogship\PapCo\Providers\PapCoServiceProvider" --tag="view"


## URLs and APIs


### Web Urls

**Admin**

    http://path-to-route-folder/admin/pap_co/{modulename}

**User**

    http://path-to-route-folder/user/pap_co/{modulename}

**Public**

    http://path-to-route-folder/pap_cos


### API endpoints

**List**
 
    http://path-to-route-folder/api/user/pap_co/{modulename}
    METHOD: GET

**Create**

    http://path-to-route-folder/api/user/pap_co/{modulename}
    METHOD: POST

**Edit**

    http://path-to-route-folder/api/user/pap_co/{modulename}/{id}
    METHOD: PUT

**Delete**

    http://path-to-route-folder/api/user/pap_co/{modulename}/{id}
    METHOD: DELETE

**Public List**

    http://path-to-route-folder/api/pap_co/{modulename}
    METHOD: GET

**Public Single**

    http://path-to-route-folder/api/pap_co/{modulename}/{slug}
    METHOD: GET