<?php

namespace Litecms\Calllist\Repositories\Eloquent;

use Litecms\Calllist\Interfaces\CalllistRepositoryInterface;
use Litepie\Repository\BaseRepository;
use Litecms\Calllist\Repositories\Eloquent\Presenters\CalllistItemPresenter;


class CalllistRepository extends BaseRepository implements CalllistRepositoryInterface
{

    public function boot()
    {
        $this->fieldSearchable = config('litecms.calllist.calllist.model.search');
    }

    /**
     * Specify Model class name.
     *
     * @return string
     */
    public function model()
    {
        return config('litecms.calllist.calllist.model.model');
    }

    /**
     * Returns the default presenter if none is availabale.
     *
     * @return void
     */
    public function presenter()
    {
        return CalllistItemPresenter::class;
    }
}
