<?php

namespace Litecms\Calllist\Providers;

use Illuminate\Support\ServiceProvider;
use Litecms\Calllist\Calllists;

class CalllistServiceProvider extends ServiceProvider
{
    /**
     * Indicates if loading of the provider is deferred.
     *
     * @var bool
     */
    protected $defer = true;

    /**
     * Bootstrap the application events.
     *
     * @return void
     */
    public function boot()
    {
        // Load view
        $this->loadViewsFrom(__DIR__ . '/../../resources/views', 'calllist');

        // Load translation
        $this->loadTranslationsFrom(__DIR__ . '/../../resources/lang', 'calllist');

        // Load migrations
        $this->loadMigrationsFrom(__DIR__ . '/../../database/migrations');

        // Call pblish redources function
        $this->publishResources();

    }

    /**
     * Register the service provider.
     *
     * @return void
     */
    public function register()
    {
        $this->mergeConfig();
        $this->registerFacade();
        $this->registerBindings();
        //$this->registerCommands();

        $this->app->register(\Litecms\Calllist\Providers\AuthServiceProvider::class);
        $this->app->register(\Litecms\Calllist\Providers\RouteServiceProvider::class);
        // $this->app->register(\Litecms\Calllist\Providers\EventServiceProvider::class);
        // $this->app->register(\Litecms\Calllist\Providers\WorkflowServiceProvider::class);
    }

    /**
     * Register the vault facade without the user having to add it to the app.php file.
     *
     * @return void
     */
    public function registerFacade() {
        $this->app->bind('litecms.calllist', function($app)
        {
            return $this->app->make(Calllists::class);
        });
    }

    /**
     * Register the bindings for the service provider.
     *
     * @return void
     */
    public function registerBindings() {
                // Bind Calllist to repository
        $this->app->bind(
            'Litecms\Calllist\Interfaces\CalllistRepositoryInterface',
            \Litecms\Calllist\Repositories\Eloquent\CalllistRepository::class
        );
    }


    /**
     * Merges user's and calllist's configs.
     *
     * @return void
     */
    protected function mergeConfig()
    {
        $this->mergeConfigFrom(
            __DIR__ . '/../../config/config.php', 'litecms.calllist'
        );
    }

    /**
     * Register scaffolding command
     */
    protected function registerCommands()
    {
        if ($this->app->runningInConsole()) {
            $this->commands([
                \Litecms\Calllist\Commands\Calllist::class,
            ]);
        }
    }
    /**
     * Get the services provided by the provider.
     *
     * @return array
     */
    public function provides()
    {
        return ['litecms.calllist'];
    }

    /**
     * Publish resources.
     *
     * @return void
     */
    private function publishResources()
    {
        // Publish configuration file
        $this->publishes([__DIR__ . '/../../config/config.php' => config_path('litecms/calllist.php')], 'config');

        // Publish admin view
        $this->publishes([__DIR__ . '/../../resources/views' => base_path('resources/views/vendor/calllist')], 'view');

        // Publish language files
        $this->publishes([__DIR__ . '/../../resources/lang' => base_path('resources/lang/vendor/calllist')], 'lang');

        // Publish public files and assets.
        $this->publishes([__DIR__ . '/public/' => public_path('/')], 'public');
    }
}
