<?php

namespace Litecms\Calllist\Policies;

use Litepie\User\Interfaces\UserPolicyInterface;
use Litecms\Calllist\Models\Calllist;

class CalllistPolicy
{

    /**
     * Determine if the given user can view the calllist.
     *
     * @param UserPolicyInterface $authUser
     * @param Calllist $calllist
     *
     * @return bool
     */
    public function view(UserPolicyInterface $authUser, Calllist $calllist)
    {
        if ($authUser->canDo('calllist.calllist.view') && $authUser->isAdmin()) {
            return true;
        }

        return $calllist->user_id == user_id() && $calllist->user_type == user_type();
    }

    /**
     * Determine if the given user can create a calllist.
     *
     * @param UserPolicyInterface $authUser
     *
     * @return bool
     */
    public function create(UserPolicyInterface $authUser)
    {
        return  $authUser->canDo('calllist.calllist.create');
    }

    /**
     * Determine if the given user can update the given calllist.
     *
     * @param UserPolicyInterface $authUser
     * @param Calllist $calllist
     *
     * @return bool
     */
    public function update(UserPolicyInterface $authUser, Calllist $calllist)
    {
        if ($authUser->canDo('calllist.calllist.edit') && $authUser->isAdmin()) {
            return true;
        }

        return $calllist->user_id == user_id() && $calllist->user_type == user_type();
    }

    /**
     * Determine if the given user can delete the given calllist.
     *
     * @param UserPolicyInterface $authUser
     *
     * @return bool
     */
    public function destroy(UserPolicyInterface $authUser, Calllist $calllist)
    {
        return $calllist->user_id == user_id() && $calllist->user_type == user_type();
    }

    /**
     * Determine if the given user can verify the given calllist.
     *
     * @param UserPolicyInterface $authUser
     *
     * @return bool
     */
    public function verify(UserPolicyInterface $authUser, Calllist $calllist)
    {
        if ($authUser->canDo('calllist.calllist.verify')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given calllist.
     *
     * @param UserPolicyInterface $authUser
     *
     * @return bool
     */
    public function approve(UserPolicyInterface $authUser, Calllist $calllist)
    {
        if ($authUser->canDo('calllist.calllist.approve')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the user can perform a given action ve.
     *
     * @param [type] $authUser    [description]
     * @param [type] $ability [description]
     *
     * @return [type] [description]
     */
    public function before($authUser, $ability)
    {
        if ($authUser->isSuperuser()) {
            return true;
        }
    }
}
