<?php

namespace Litecms\Calllist\Http\Controllers;

use App\Http\Controllers\PublicController as BaseController;
use App\Http\Requests\PublicRequest;
use Litepie\Repository\Filter\RequestFilter;

use Litecms\Calllist\Interfaces\CalllistRepositoryInterface;
use Litecms\Calllist\Repositories\Eloquent\Filters\CalllistPublicFilter;
use Litecms\Calllist\Repositories\Eloquent\Presenters\CalllistListPresenter;

class CalllistPublicController extends BaseController
{

    /**
     * Constructor.
     *
     * @return void
     */
    public function __construct(
        CalllistRepositoryInterface $calllist
    ) {
        parent::__construct();
        $this->modules = $this->modules(config('litecms.calllist.modules'), 'calllist', guard_url('calllist'));
        $this->repository = $calllist;
    }

    /**
     * Show calllist's list.
     *
     * @return response
     */
    protected function index(PublicRequest $request)
    {

        $search = $request->search;
        $pageLimit = $request->input('pageLimit', config('database.pagination.limit'));
        $data = $this->repository
            ->pushFilter(RequestFilter::class)
            ->pushFilter(CalllistPublicFilter::class)
            ->setPresenter(CalllistListPresenter::class)
            ->select('calllists.*')
            ->paginate($pageLimit)
            ->withQueryString()
            ->toArray();

        extract($data);

        $categories = [];
        $tags = [];
        $recent = [];

        return $this->response->setMetaTitle(trans('calllist::calllist.names'))
            ->view('calllist::public.calllist.index')
            ->data(compact('data', 'meta', 'categories', 'tags', 'recent'))
            ->output();
    }

    /**
     * Show calllist.
     *
     * @param string $slug
     *
     * @return response
     */
    protected function show(PublicRequest $request, $slug)
    {
        $data = $this->repository
            ->findBySlug($slug)
            ->toArray();

        $categories = [];
        $tags = [];
        $recent = [];
    
        return $this->response->setMetaTitle($data['title'] . trans('calllist::calllist.name'))
            ->view('calllist::public.calllist.show')
            ->data(compact('data', 'categories', 'tags', 'recent'))
            ->output();
    }

}
