<?php

namespace Litecms\Calllist\Forms;

use Litepie\Form\FormInterpreter;

class Calllist extends FormInterpreter
{

    /**
     * Sets the form and form elements.
     * @return null.
     */
    public static function setAttributes()
    {

        self::$urls = [
            'new' => [
                'url' => guard_url('calllist/calllist/new'),
                'method' => 'GET',
            ],
            'create' => [
                'url' => guard_url('calllist/calllist/create'),
                'method' => 'GET',
            ],
            'store' => [
                'url' => guard_url('calllist/calllist'),
                'method' => 'POST',
            ],
            'update' => [
                'url' => guard_url('calllist/calllist'),
                'method' => 'PUT',
            ],
            'list' => [
                'url' => guard_url('calllist/calllist'),
                'method' => 'GET',
            ],
            'delete' => [
                'url' => guard_url('calllist/calllist'),
                'method' => 'DELETE',
            ],
        ];
        self::$search = [
            'name' => [
                "type" => 'text',
                "label" => trans('calllist::calllist.label.name'),
                "placeholder" => trans('calllist::calllist.placeholder.name'),
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "4",
                "roles" => [],
            ]
        ];
        self::$orderBy = [
            'created_at' => trans('calllist::calllist.label.created_at'),
            'name' => trans('calllist::calllist.label.name'),
            'status' => trans('calllist::calllist.label.status'),
        ];
        self::$groups = [
            'main' => trans('calllist::calllist.groups.main'),
            'details' => trans('calllist::calllist.groups.details'),
            'images' => trans('calllist::calllist.groups.images'),
            'settings' => trans('calllist::calllist.groups.settings'),
        ];
        self::$list = [
            [
                'key' => "ref",
                'label' => trans('calllist::calllist.label.ref'),
                'sortable' => 'true',
                'roles' => [],
            ],
            [
                'key' => "id",
                'label' => trans('calllist::calllist.label.id'),
                'sortable' => 'true',
                'roles' => [],
            ],
            [
                'key' => "name",
                'label' => trans('calllist::calllist.label.name'),
                'sortable' => 'true',
                'roles' => [],
            ],
            [
                'key' => "status",
                'label' => trans('calllist::calllist.label.status'),
                'sortable' => 'true',
                'roles' => [],
            ],
        ];
        self::$fields = [
                
        ];

        return new static();
    }
}
