Lavalite package that provides calllist management facility for the cms.

## Installation

Begin by installing this package through Composer. Edit your project's `composer.json` file to require `litecms/calllist`.

    "litecms/calllist": "dev-master"

Next, update Composer from the Terminal:

    composer update

Once this operation completes execute below cammnds in command line to finalize installation.

    Litecms\Calllist\Providers\CalllistServiceProvider::class,

And also add it to alias

    'Calllist'  => Litecms\Calllist\Facades\Calllist::class,

## Publishing files and migraiting database.

**Migration and seeds**

    php artisan migrate
    php artisan db:seed --class=Litecms\\Calllist\\Seeders\\CalllistTableSeeder

**Publishing configuration**

    php artisan vendor:publish --provider="Litecms\Calllist\Providers\CalllistServiceProvider" --tag="config"

**Publishing language**

    php artisan vendor:publish --provider="Litecms\Calllist\Providers\CalllistServiceProvider" --tag="lang"

**Publishing views**

    php artisan vendor:publish --provider="Litecms\Calllist\Providers\CalllistServiceProvider" --tag="view"


### Web Urls

**Admin**

    http://path-to-route-folder/admin/calllist/{modulename}

**User**

    http://path-to-route-folder/user/calllist/{modulename}

**Public**

    http://path-to-route-folder/calllists


### API endpoints

**List**

    http://path-to-route-folder/api/user/calllist/{modulename}
    METHOD: GET

**Create**

    http://path-to-route-folder/api/user/calllist/{modulename}
    METHOD: POST

**Edit**

    http://path-to-route-folder/api/user/calllist/{modulename}/{id}
    METHOD: PUT

**Delete**

    http://path-to-route-folder/api/user/calllist/{modulename}/{id}
    METHOD: DELETE

**Public List**

    http://path-to-route-folder/api/calllist/{modulename}
    METHOD: GET

**Public Single**

    http://path-to-route-folder/api/calllist/{modulename}/{slug}
    METHOD: GET