# Installation

The instructions below will help you to properly install the generated package to the lavalite project.

## Location

Extract the package contents to the folder 

`/packages/litecms/calllist/`

## Composer

Add the below entries in the `composer.json` file's autoload section and run the command `composer dump-autoload` in terminal.

```json

...
     "autoload": {

        "psr-4": {
            ... ,
            "Litecms\\Calllist\\": "packages/litecms/calllist/src",
            "Litecms\\Calllist\\Seeders\\": "packages/litecms/calllist/database/seeders"
            
            ...
        }
    },
...

```

## Config

Add the entries in service provider in `config/app.php`

```php

...
    'providers'       => [
        ...
        
        Litecms\Calllist\Providers\CalllistServiceProvider::class,
        
        ...
    ],

    ...

    'alias'             => [
        ...
        
        'Calllist'  => Litecms\Calllist\Facades\Calllist::class,
        
        ...
    ]
...

```

## Migrate

After service provider is set run the commapnd to migrate and seed the database.


    php artisan migrate
    php artisan db:seed --class=Litecms\\Calllist\\Seeders\\CalllistTableSeeder

## Publishing


**Publishing configuration**

    php artisan vendor:publish --provider="Litecms\Calllist\Providers\CalllistServiceProvider" --tag="config"

**Publishing language**

    php artisan vendor:publish --provider="Litecms\Calllist\Providers\CalllistServiceProvider" --tag="lang"

**Publishing views**

    php artisan vendor:publish --provider="Litecms\Calllist\Providers\CalllistServiceProvider" --tag="view"


## URLs and APIs


### Web Urls

**Admin**

    http://path-to-route-folder/admin/calllist/{modulename}

**User**

    http://path-to-route-folder/user/calllist/{modulename}

**Public**

    http://path-to-route-folder/calllists


### API endpoints

**List**
 
    http://path-to-route-folder/api/user/calllist/{modulename}
    METHOD: GET

**Create**

    http://path-to-route-folder/api/user/calllist/{modulename}
    METHOD: POST

**Edit**

    http://path-to-route-folder/api/user/calllist/{modulename}/{id}
    METHOD: PUT

**Delete**

    http://path-to-route-folder/api/user/calllist/{modulename}/{id}
    METHOD: DELETE

**Public List**

    http://path-to-route-folder/api/calllist/{modulename}
    METHOD: GET

**Public Single**

    http://path-to-route-folder/api/calllist/{modulename}/{slug}
    METHOD: GET