<?php

namespace Litecms\Calllist\Seeders;

use DB;
use Illuminate\Database\Seeder;

class CalllistTableSeeder extends Seeder
{
    public function run()
    {
        DB::table('calllists')->insert([
            
        ]);

        DB::table('permissions')->insert([
            [
                'slug'      => 'calllist.calllist.view',
                'name'      => 'View Calllist',
            ],
            [
                'slug'      => 'calllist.calllist.create',
                'name'      => 'Create Calllist',
            ],
            [
                'slug'      => 'calllist.calllist.edit',
                'name'      => 'Update Calllist',
            ],
            [
                'slug'      => 'calllist.calllist.delete',
                'name'      => 'Delete Calllist',
            ],
            
            
        ]);

        DB::table('menus')->insert([
        
            // Admin menu
            [
                'parent_id'   => 1,
                'key'         => null,
                'url'         => 'admin/calllist/calllist',
                'name'        => 'Calllist',
                'description' => null,
                'icon'        => 'fa fa-newspaper-o',
                'target'      => null,
                'order'       => 190,
                'status'      => 1,
            ],
            
            // User menu.
            [
                'parent_id'   => 2,
                'key'         => null,
                'url'         => 'user/calllist/calllist',
                'name'        => 'Calllist',
                'description' => null,
                'icon'        => 'icon-book-open',
                'target'      => null,
                'order'       => 190,
                'status'      => 1,
            ],

            // Public menu.
            [
                'parent_id'   => 3,
                'key'         => null,
                'url'         => 'calllist',
                'name'        => 'Calllist',
                'description' => null,
                'icon'        => null,
                'target'      => null,
                'order'       => 190,
                'status'      => 1,
            ],

        ]);

        DB::table('settings')->insert([
            // Uncomment  and edit this section for entering value to settings table.
            /*
            [
                'pacakge'   => 'Calllist',
                'module'    => 'Calllist',
                'user_type' => null,
                'user_id'   => null,
                'key'       => 'calllist.calllist.key',
                'name'      => 'Some name',
                'value'     => 'Some value',
                'type'      => 'Default',
                'control'   => 'text',
            ],
            */
        ]);
    }
}
